//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "pem.h"
#include "include\PEMDll.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

  bool Pin42_flag=true;
  bool Pin44_flag=true;
  bool Pin46_flag=true;

TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
        int status;

        status=PETS_INIT();
       if(status)
       {
        Application->MessageBox("No PEM-1x Extender Card On System !", "Look", MB_OK);
        Close();
        }
        else
        {
        //*********************************************************
                currpemno = Edit_PEM_Addr->Text.ToInt();
                PETS_GPIOSETUP1(currpemno,1, 1, 0);  //Pin 42
                PETS_GPIOSETUP1(currpemno,2, 1, 0);  //Pin 44
                PETS_GPIOSETUP1(currpemno,3, 1, 0);  //Pin 46
        //******************************************************

        //Application->MessageBox("PEM-1x Extender Card On System !", "Look", MB_OK);
        }
}

//---------------------------------------------------------------------------

void __fastcall TForm1::BT_CHKPEMClick(TObject *Sender)
{
        int rtn;
        currpemno = Edit_PEM_Addr->Text.ToInt();
        if (currpemno <0 && currpemno>=4)
        {
                Edit_PEM_Addr->Text = "Addr Error";
                return;
        }
        rtn = PETS_VALIDPEM(currpemno);
        rtn = 5;
        rtn = PETS_SELPEM(currpemno);
        if (rtn ==0)
               LB_PEM_Status->Caption = "CHK Pass";
        else
               LB_PEM_Status->Caption = "CHK Fail";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_SelectDevClick(TObject *Sender)
{
        int rtnchk =55;
        DUT_Busno = Edit_BusNo->Text.ToInt();
        DUT_Devno = Edit_DevNo->Text.ToInt();
        PETS_SELDEVBD(DUT_Busno,DUT_Devno);
        rtnchk = PETS_VALIDDEV();

        if (rtnchk ==1)
               LB_DEVStatus->Caption = "SEL DEV Pass";
        else
               LB_DEVStatus->Caption = "SEL DEV Fail";

}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_ExitClick(TObject *Sender)
{
        PETS_EXIT();
   Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::BTDrv_WinDisClick(TObject *Sender)
{
     //Syntax: PETS_WINDIS1(DWORD addr, int delaytime)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Disable the windows driver of the specified PCI-Express Device on PEM-1X module.
     //Return Value: Return 0 if successful; 1 if error;

     //Syntax:PETS_ WINCHECK1(DWORD addr)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Check if the windows driver of the specified PCI-Express Device on PEM-1X module is enabled.
     //Return Value: Return 0 if driver are dsiabled; 1 if driver are enabled.

   int status;
   currpemno = Edit_PEM_Addr->Text.ToInt();
   status=PETS_WINCHECK1(currpemno);
   if(status!=0)
   {
        status=PETS_WINDIS1(currpemno,100);
        if (status != 0)
        {
        Application->MessageBox("Failed to disable DUT driver by PEM-1x", "Look", MB_OK);
        }
   }
   else
   {
   Application->MessageBox("DUT driver had been disabled by PEM-1x", "Look", MB_OK);
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::BTDrv_WinEnClick(TObject *Sender)
{
     //Syntax: PETS_WINEN21(DWORD addr, int delaytime)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Enable the windows driver of the specified PCI-Express Device on PEM-1X module.
     //Return Value: Return 0 if successful; 1 if error; -2 if power off

     //Syntax:PETS_WINCHECK1(DWORD addr)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Check if the windows driver of the specified PCI-Express Device on PEM-1X module is enabled.
     //Return Value: Return 0 if driver are dsiabled; 1 if driver are enabled.

   int status;
   currpemno = Edit_PEM_Addr->Text.ToInt();
   status =PETS_GETPWRSTS1(currpemno);
   if(status == 1 )
   {
        status=PETS_WINCHECK1(currpemno);
        if(status != 1)
        {
                status=PETS_WINEN21(currpemno,500);
                if( status !=0)
                {
                  Application->MessageBox("Failed to enable DUT driver by PEM-1x.", "Look", MB_OK);
                }
        }
        else
        {
           Application->MessageBox("DUT driver had been enabled by PEM-1x.", "Look", MB_OK);
        }

   }
   else
   {
     Application->MessageBox("Please make sure PEM-1x card has been power on", "Look", MB_OK);
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_PoffClick(TObject *Sender)
{

     //Syntax: GETPWRSTS(DWORD addr)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Get the power status of the specified PEM-1X module
     //Return Value: Return 0 if power off ; 1 if power on; -1 if error.

     //Syntax: POFF(DWORD addr)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Turn the specified PEM-1X module power off.
     //Return Value: Return 0 if successful; 1 if error.

     int status;
     currpemno = Edit_PEM_Addr->Text.ToInt();
     status =PETS_GETPWRSTS1(currpemno);
     if(status == 1 )
     {
        status=PETS_POFF1(currpemno);
        if (status != 0)
        {
         //Failed to PEM-1x power off
          Application->MessageBox("Failed to PEM-1x power off!", "Look", MB_OK);
        }
     }
     else if (status == 0 )
     {
        Application->MessageBox("PEM-1x had been power off.", "Look", MB_OK);

     }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_PonClick(TObject *Sender)
{
     //Syntax: PETS_GETPWRSTS1(DWORD addr)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Get the power status of the specified PEM-1X module
     //Return Value: Return 0 if power off ; 1 if power on; -1 if error.

     //Syntax: PETS_PON1(DWORD addr)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Turn the specified PEM-1X module power on.
     //Return Value: Return 0 if successful; 1 if error; 4 if power off.

     //Syntax:PETS_CHKSHORT1(DWORD addr)
     //addr: PEM-1x module address, range 0~3 (Default :3)
     //Description: Check which power rail is shorted.
     //Return Value: Return -1 if error,0 if normal, 0x01 if 1.5V rail short
     //              0x02 if 3.3V rail short ,0x04 if 3.3VAux rail short.

     int status;
     currpemno = Edit_PEM_Addr->Text.ToInt();
     status =PETS_GETPWRSTS1(currpemno);
     if(status == 0 )
     {
         status=PETS_PON1(currpemno);
         Sleep(1000);
         if (status != 0)
         {
           //Failed to PEM-1x power on
           Application->MessageBox("Failed to PEM-1x power on!", "Look", MB_OK);
         }
         else if( status==4 ) //Short circuit detected on PEM-1x
         {
            status=PETS_CHKSHORT1(currpemno);
            switch( status)
            {
                case 1:
                           Application->MessageBox("Short circuit detected on 1.5V at PEM-1x!", "Look", MB_OK);
			   break;
		case 2:

                           Application->MessageBox("Short circuit detected on 3.3V at at PEM-1x!", "Look", MB_OK);
			   break;
		case 3:
                            Application->MessageBox("Short circuit detected on 1.5V and 3.3V at at PEM-1x!", "Look", MB_OK);
			   break;
		case 4:

                            Application->MessageBox("Short circuit detected on 3.3Vaux at at PEM-1x!", "Look", MB_OK);
			   break;
		case 5:

                            Application->MessageBox("Short circuit detected on 1.5V  and 3.3Vaux at at PEM-1x!", "Look", MB_OK);
			   break;
		case 6:

                           Application->MessageBox("Short Circuit detected on 3.3V and 3.3Vaux at at PEM-1x!", "Look", MB_OK);
			   break;
		case 7:

                           Application->MessageBox("Short circuit detected on 1.5V B3.3V B3.3Vaux at at PEM-1x!", "Look", MB_OK);
			   break;
		default:
			   break;
            
            }

         }
     }
     else if( status == 1)
     {
       Application->MessageBox("PEM-1x had been power on.", "Look", MB_OK);
     }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_BEEPClick(TObject *Sender)
{
        PETS_BEEP(3, 500);
        PETS_BEEP(3, 500);
}
//---------------------------------------------------------------------------




void __fastcall TForm1::BT_GPIO1_pin42Click(TObject *Sender)
{
        int status;
	//**************************************
        currpemno = Edit_PEM_Addr->Text.ToInt();
        PETS_GPIOSETUP1(currpemno,1,1,0);
        //**************************************
        BT_GPIO1_pin42->Caption="GPIO-1 Output (H)";
        if(Pin42_flag == true)
	{
		//***********************
		status=PETS_GPIOOUTSET1(currpemno,1);
		//***********************
		BT_GPIO1_pin42->Caption="GPIO-1 Output (H)";
		LB_GPIO1_Satus->Caption="(H)";
	}
   	else
	{
		//***********************
		status=PETS_GPIOOUTRESET1(currpemno,1);
		//***********************
		BT_GPIO1_pin42->Caption="GPIO-1 Output (L)";
		LB_GPIO1_Satus->Caption="(L)";
	}
	Pin42_flag=!Pin42_flag;

}
//---------------------------------------------------------------------------



void __fastcall TForm1::BT_GPIO2_pin44Click(TObject *Sender)
{
        int status;
	//**************************************
        currpemno = Edit_PEM_Addr->Text.ToInt();
        PETS_GPIOSETUP1(currpemno,2,1,0);
        //**************************************
        BT_GPIO2_pin44->Caption="GPIO-2 Output (H)";
        if(Pin44_flag == true)
	{
		//***********************
		status=PETS_GPIOOUTSET1(currpemno,2);
		//***********************
		BT_GPIO2_pin44->Caption="GPIO-2 Output (H)";
		LB_GPIO2_Satus->Caption="(H)";
	}
   	else
	{
		//***********************
		status=PETS_GPIOOUTRESET1(currpemno,2);
		//***********************
		BT_GPIO2_pin44->Caption="GPIO-2 Output (L)";
		LB_GPIO2_Satus->Caption="(L)";
	}
	Pin44_flag=!Pin44_flag;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_GPIO3_pin46Click(TObject *Sender)
{
        int status;
	//**************************************
        currpemno = Edit_PEM_Addr->Text.ToInt();
        PETS_GPIOSETUP1(currpemno,3,1,0);
        //**************************************
        BT_GPIO3_pin46->Caption="GPIO-3 Output (H)";
        if(Pin46_flag == true)
	{
		//***********************
		status=PETS_GPIOOUTSET1(currpemno,3);
		//***********************
		BT_GPIO3_pin46->Caption="GPIO-3 Output (H)";
		LB_GPIO3_Satus->Caption="(H)";
	}
   	else
	{
		//***********************
		status=PETS_GPIOOUTRESET1(currpemno,3);
		//***********************
		BT_GPIO3_pin46->Caption="GPIO-3 Output (L)";
		LB_GPIO3_Satus->Caption="(L)";
	}
	Pin46_flag=!Pin46_flag;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_GPIO1_InputClick(TObject *Sender)
{
        int value=0, status=0;
        currpemno = Edit_PEM_Addr->Text.ToInt();
        //*********************
        PETS_GPIOSETUP1(currpemno,1,0,0);
        //*********************
	status=PETS_GPIOGETSETUP1(currpemno,1);
	value=PETS_GPIOIN1(currpemno,1);
	if(value == 0) LB_GPIO1_Satus->Caption="(L)";
	else if(value == 1) LB_GPIO1_Satus->Caption="(H)";

}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_GPIO2_InputClick(TObject *Sender)
{
        int value=0, status=0;
        currpemno = Edit_PEM_Addr->Text.ToInt();
        //*********************
        PETS_GPIOSETUP1(currpemno,2,0,0);
        //*********************
	status=PETS_GPIOGETSETUP1(currpemno,2);
	value=PETS_GPIOIN1(currpemno,2);
	if(value == 0) LB_GPIO2_Satus->Caption="(L)";
	else if(value == 1) LB_GPIO2_Satus->Caption="(H)";

}
//---------------------------------------------------------------------------

void __fastcall TForm1::BT_GPIO3_InputClick(TObject *Sender)
{
        int value=0, status=0;
        currpemno = Edit_PEM_Addr->Text.ToInt();
        //*********************
        PETS_GPIOSETUP1(currpemno,3,0,0);
        //*********************
	status=PETS_GPIOGETSETUP1(currpemno,3);
	value=PETS_GPIOIN1(currpemno,3);
	if(value == 0) LB_GPIO3_Satus->Caption="(L)";
	else if(value == 1) LB_GPIO3_Satus->Caption="(H)";

}
//---------------------------------------------------------------------------

